//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace Scribble
{
	/// <summary>
	/// Podsumowanie dla ScribbleForm.
	/// </summary>
	public class ScribbleForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private Graphics graphics = null;
		private Point lastPoint;
		public ScribbleForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// ScribbleForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.Window;
			this.ClientSize = new System.Drawing.Size(292, 266);
			this.Name = "ScribbleForm";
			this.Text = "Scribble";
			this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.OnMouseDown);
			this.MouseUp += new System.Windows.Forms.MouseEventHandler(this.OnMouseUp);
			this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.OnMouseMove);
			this.MouseLeave += new System.EventHandler(this.OnMouseLeave);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ScribbleForm());
		}

		private void OnMouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if(graphics != null)
			{
				Point currentPoint = new Point(e.X, e.Y);
				graphics.DrawLine(new Pen(Color.Red), lastPoint, currentPoint);
				lastPoint = currentPoint;
			}
		}

		private void OnMouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			graphics = CreateGraphics();
			lastPoint = new Point(e.X, e.Y);
		}

		private void OnMouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			graphics.Dispose();
			graphics = null;
		}

		private void OnMouseLeave(object sender, System.EventArgs e)
		{
			if(graphics != null)
			{
				graphics.Dispose();
				graphics = null;
			}
		}
	}
}
